####################################################
### code chunk number : Simulations: Goodness-of-fit, K-S test
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 3; alpha            ## hyperparameter
beta = 2; beta              ## hyperparameter
n = 1000; n                 ## sample size
M0 = 100; M0                ## number of required simulations
M1 = 150; M1                ## number of maximum tried simulations
## M2: number of actually tried simulations
## M:  number of effective simulations, finally M = M0

alpha_1 = beta_1 = alpha_2 = beta_2 = numeric(M1)
D_0 = D_1 = D_2 = p_value_0 = p_value_1 = p_value_2 = numeric(M1)
Index = numeric(M1)
names(Index) = 1:M1
Index_MLE_warning_error = Index_alpha_1_beta_1_negative = Index
M = 0
ptm = proc.time()
for (m in 1:M1){
  cat("\n"); print(paste("In this cycle, m = ", m, sep = "")); cat("\n")
  M = M + 1
  
  ## simulate the sample
  set.seed(m)
  theta_m = 1 / rgamma(n, shape = alpha, scale = 1/beta)
  x = x_m = rexp(n, rate = 1/theta_m)
  
  ## Moment estimators
  alpha_1_beta_1_m = Moment_estimators_EX_EX2(x_m)
  cat("\n alpha_1_beta_1_m\n"); print(alpha_1_beta_1_m); cat("\n")
  alpha_1[m] = alpha_1_beta_1_m[1]
  beta_1[m] = alpha_1_beta_1_m[2]
  
  ## MLEs
  p_m = alpha_1_beta_1_m
  alpha_2_beta_2_m = tryCatch ( {
    Newtons(fun = moment_fun, y = p_m)$root
  } , warning = function ( w ) {
    alpha_1_beta_1_m
  } , error = function ( e ) {
    alpha_1_beta_1_m
  } , finally = {
    ""
  }
  )
  
  if (all(alpha_2_beta_2_m == alpha_1_beta_1_m)){
    cat("\n alpha_2_beta_2_m = alpha_1_beta_1_m\n")
    Index_MLE_warning_error[m] = 1
  }
  
  # alpha_2_beta_2_m = Newtons(fun = moment_fun, y = p_m)$root
  cat("\n alpha_2_beta_2_m\n"); print(alpha_2_beta_2_m); cat("\n")
  alpha_2[m] = alpha_2_beta_2_m[1]
  beta_2[m] = alpha_2_beta_2_m[2]
  
  ## 
  ## ks.test
  ## 
  
  ## Exp_IG(3, 2)
  ks_test_0_m = ks.test(x_m, "p_Exp_IG_alpha_Beta", alpha, beta)
  cat("\n ks_test_0_m\n"); print(ks_test_0_m); cat("\n")
  D_0[m] = ks_test_0_m$statistic
  p_value_0[m] = ks_test_0_m$p.value
  
  if (any(alpha_1_beta_1_m < 0)){
    Index_alpha_1_beta_1_negative[m] = 1
    M = M - 1
    D_1[m] = D_2[m] = NA
    p_value_1[m] = p_value_2[m] = NA
  }
  else{
    ## Exp_IG(alpha_1, beta_1)
    ks_test_1_m = ks.test(x_m, "p_Exp_IG_alpha_Beta", alpha_1[m], beta_1[m])
    cat("\n ks_test_1_m\n"); print(ks_test_1_m); cat("\n")
    D_1[m] = ks_test_1_m$statistic
    p_value_1[m] = ks_test_1_m$p.value
    
    ## Exp_IG(alpha_2, beta_2)
    ks_test_2_m = ks.test(x_m, "p_Exp_IG_alpha_Beta", alpha_2[m], beta_2[m])
    cat("\n ks_test_2_m\n"); print(ks_test_2_m); cat("\n")
    D_2[m] = ks_test_2_m$statistic
    p_value_2[m] = ks_test_2_m$p.value
  }
  
  if (M == M0){
    M2 = m
    cat("\n"); print(paste("M == M0, M2 = ", m, sep = "")); cat("\n")
    break
  }
}
Index_MLE_warning_error
sum(Index_MLE_warning_error)
Index_alpha_1_beta_1_negative
sum(Index_alpha_1_beta_1_negative)

D_M1 = cbind(D_0, D_1, D_2); 
# round(D_M1, 4)
p_value_M1 = cbind(p_value_0, p_value_1, p_value_2); 
# round(p_value_M1, 4)

keep_rows = (Index_alpha_1_beta_1_negative == 0)[1:M2]; keep_rows
length(keep_rows)
D_M0 = D_M1[1:M2, ][keep_rows, ]; round(D_M0, 4)
p_value_M0 = p_value_M1[1:M2, ][keep_rows, ]; round(p_value_M0, 4)

## compute averages
Average_D_M0 = colMeans(D_M0); round(Average_D_M0, 4)
Average_p_value_M0 = colMeans(p_value_M0); round(Average_p_value_M0, 4)



## compute proportions
source("subfunctions.R")
Proportions_D_M0 = Compute_Proportions_vector_pmin(D_M0[, 1], D_M0[, 2], D_M0[, 3])
round(Proportions_D_M0, 3)

Proportions_p_value_M0 = Compute_Proportions_vector_pmax(p_value_M0[, 1], p_value_M0[, 2], p_value_M0[, 3])
round(Proportions_p_value_M0, 3)

Proportions_accept_H0 = colMeans(p_value_M0 > 0.05)
round(Proportions_accept_H0, 3)

## summarize the results
A = matrix(0, nrow = 5, ncol = 3)
colnames(A) = c("oracle", "moment", "mle")
rownames(A) = c("Average_D_M0", "Average_p_value_M0", "Proportions_D_M0", "Proportions_p_value_M0", "Proportions_accept_H0")
A[1, ] = round(Average_D_M0, 4)
A[2, ] = round(Average_p_value_M0, 4)
A[3, ] = round(Proportions_D_M0, 3)
A[4, ] = round(Proportions_p_value_M0, 3)
A[5, ] = round(Proportions_accept_H0, 3)
A

Generate_Matrix_Latex(A)

## boxplots
names = c("oracle", "moment", "mle")
col = c("red", "purple", "blue")

dev.new()
boxplot(D_M0[, 1], D_M0[, 2], D_M0[, 3], names = names, col = col, sub = "(a)")
title("D values")
savePlot(filename = paste("figure/Exp-IG_D_values", sep=""), type = c("pdf"))


dev.new()
boxplot(p_value_M0[, 1], p_value_M0[, 2], p_value_M0[, 3], names = names, col = col, sub = "(b)")
title("p-values")
savePlot(filename = paste("figure/Exp-IG_p_values", sep=""), type = c("pdf"))

Time_all = (proc.time() - ptm)[3]; Time_all
